/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBWidgetCounter = Object.create(STBModule.prototype);

STBWidgetCounter.name = "WidgetCounter";
STBWidgetCounter.initPlugin = function() {

	var elements = $('.widget-counter-up .counter:not(.__done)');

	if (elements.length > 0) {
		elements.each(function() {

			var el = $(this);

			if (STBGlobalPreloader.isVisible())	{
				el.data("inview-force", true);
			}

			el.on('inview', function (event, isInView) {
			
				if (isInView) {
					if (!STBGlobalPreloader.isVisible())	{

						console.log("z");

						el.counterUp({
							delay: 10,
							time: 1000
						});

						el.off("inview");

					} 
				}
			});

			el.addClass("__done");

		});
	}
}


STBWidgetCounter.runOnReady = function() {
	STBWidgetCounter.initPlugin();
}

STBWidgetCounter.runOnContentUpdate = function() {
	STBWidgetCounter.initPlugin();
}

site.registerModule(STBWidgetCounter);